/*
 * Decompiled with CFR 0.152.
 */
package comics;

import comics.core.ComicGrabberEngineImplementation;
import comics.core.ComicImage;
import comics.core.ComicURLFactory;
import comics.core.GregorianDayRoller;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;

public class ComicGrabber {
    public static void main(String[] args) {
        if (args == null || args.length != 2 && args.length != 3) {
            System.err.println("\n\nUsage:\n\tComicGrabber <ucomics_comic_abbreviation> <output_path> [startdate_in_dd/MM/yyyy]");
            System.err.println("\n\t\tOR\n");
            System.err.println("\tComicGrabber @<details_file> <output_path>");
            System.exit(1);
        }
        String comicName = args[0];
        File parent = new File(args[1]);
        if (!parent.exists()) {
            System.err.println("\n\nThe output folder you specified ('" + args[1] + "') does not exist!\n\n");
            System.exit(1);
        }
        ComicGrabberEngineImplementation engine = new ComicGrabberEngineImplementation();
        ArrayList<Object[]> allComics = new ArrayList<Object[]>();
        Date startdate = null;
        if (args.length == 3 && args[2] != null) {
            try {
                startdate = new SimpleDateFormat("dd/MM/yyyy").parse(args[2]);
            }
            catch (ParseException pe) {
                System.err.println("\n\nPlease format date: ('" + args[2] + "') like: dd/MM/yyyy\n\n");
                System.exit(1);
            }
        }
        if (args.length == 2 && comicName.startsWith("@")) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(comicName.substring(1)));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).equals("") || line.startsWith("!") || line.startsWith("#")) continue;
                    StringTokenizer main = new StringTokenizer(line, " ");
                    int count = main.countTokens();
                    if (count != 2 && count != 3) {
                        System.err.println(" *** Could not parse line '" + line + "'. Skipping it.");
                        continue;
                    }
                    String comic = main.nextToken().trim();
                    String daysString = main.nextToken().trim();
                    String dateString = null;
                    Date date = null;
                    int[] days = null;
                    StringTokenizer inner = new StringTokenizer(daysString, ",");
                    int countInner = inner.countTokens();
                    if (inner.countTokens() == 0) {
                        System.err.println(" *** No applicable days found, skipping line '" + line + "'.");
                    } else if (countInner >= 1) {
                        String token = inner.nextToken().trim();
                        int counter = 0;
                        if (countInner > 1 || !token.equalsIgnoreCase("all")) {
                            days = new int[countInner];
                            while (true) {
                                int day;
                                if ((day = ComicGrabber.parseDay(token)) < 0) {
                                    System.err.println(" *** Unable to parse day String '" + token + "' in line, skipping line '" + line + "'. ");
                                } else {
                                    days[counter] = day;
                                }
                                ++counter;
                                if (!inner.hasMoreTokens()) break;
                                token = inner.nextToken().trim();
                            }
                        }
                    }
                    if (count == 3) {
                        dateString = main.nextToken().trim();
                        try {
                            date = new SimpleDateFormat("dd/MM/yyyy").parse(dateString);
                        }
                        catch (ParseException pe) {
                            System.err.println(" *** Incorrectly formatted date found (" + dateString + "), skipping line '" + line + "'.");
                        }
                    }
                    allComics.add(new Object[]{comic, date, days});
                }
            }
            catch (IOException ioe) {
                System.err.println("Unable to read the specified file (" + comicName.substring(1) + "): " + ioe.getMessage());
            }
        } else {
            allComics.add(new Object[]{comicName, startdate, null});
        }
        Iterator iter = allComics.iterator();
        while (iter.hasNext()) {
            Object[] value = (Object[])iter.next();
            String comic = (String)value[0];
            GregorianDayRoller roller = new GregorianDayRoller();
            Object date = value[1];
            if (date != null) {
                roller.setStartDate((Date)value[2]);
            } else {
                roller.setStartDate(new Date());
            }
            Object days = value[2];
            if (days != null) {
                roller.setApplicableDays((int[])value[1]);
            } else {
                roller.setApplicableDays(null);
            }
            roller.getCurrentDate();
            try {
                int previousError = 0;
                int previousMonth = roller.getCurrentMonth();
                int previousYear = roller.getCurrentYear();
                int totalError = 0;
                while (previousError < 14) {
                    try {
                        ComicImage image;
                        File outputFile;
                        int year = roller.getCurrentYear();
                        int month = roller.getCurrentMonth();
                        String previousMonthString = (previousMonth < 10 ? "0" : "") + Integer.toString(previousMonth);
                        String currentMonthString = (month < 10 ? "0" : "") + Integer.toString(month);
                        if (month < previousMonth || year < previousYear) {
                            System.out.println("Grabbed " + previousMonthString + "/" + previousYear + " for comic '" + comic + "'.");
                            previousMonth = month;
                            previousYear = year;
                        }
                        URL url = ComicURLFactory.createURL("UCOMICS", comic, roller.getCurrentDate());
                        File outputDir = new File(parent, comic + "/" + Integer.toString(year) + "/" + currentMonthString + "/");
                        if (!outputDir.exists()) {
                            outputDir.mkdirs();
                        }
                        if ((outputFile = new File(outputDir, (image = engine.grabComic(url)).getFilename())).exists()) {
                            System.out.println("\n* Found comic '" + outputFile.getName() + "' in output path. Updating complete.");
                            break;
                        }
                        previousError = 0;
                    }
                    catch (IOException ioe) {
                        System.err.println("Error for date " + roller.getFormattedCurrentDate("dd/MM/yyyy") + ": " + ioe.getMessage());
                        ++previousError;
                        ++totalError;
                    }
                    roller.getPreviousDay();
                }
                String last = roller.getFormattedCurrentDate("dd/MM/yyyy");
                if (previousError >= 14) {
                    System.out.println("\n\nExiting because the comic was not found for 15 consecutive days on the server.");
                } else {
                    System.out.println("\n\nExiting because update was complete.");
                }
                System.out.println("\n - Last date: " + last + "\n - Total error count: " + totalError + "\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static int parseDay(String aDayCode) {
        int result = -1;
        String code = aDayCode.trim().toLowerCase();
        if (code.equals("mon")) {
            result = 2;
        } else if (code.equals("tue")) {
            result = 3;
        } else if (code.equals("wed")) {
            result = 4;
        } else if (code.equals("thu")) {
            result = 5;
        } else if (code.equals("fri")) {
            result = 6;
        } else if (code.equals("sat")) {
            result = 7;
        } else if (code.equals("sun")) {
            result = 1;
        }
        return result;
    }
}

