/*
 * Decompiled with CFR 0.152.
 */
package comics;

import comics.core.ComicGrabberEngineImplementation;
import comics.core.ComicImage;
import comics.core.ComicURLFactory;
import comics.core.GregorianDayRoller;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;

public class NewComicGrabber {
    private static final SimpleDateFormat iSDF = new SimpleDateFormat("dd/MM/yyyy");

    public static void main(String[] args) {
        if (args == null || args.length != 2 && args.length != 3) {
            System.err.println("\n\nUsage:\n\tComicGrabber <ucomics_comic_abbreviation> <output_path> [startdate_in_dd/MM/yyyy]");
            System.err.println("\n\t\tOR\n");
            System.err.println("\tComicGrabber @<details_file> <output_path>");
            System.exit(1);
        }
        String abbreviationOrFile = args[0];
        String output = args[1];
        ArrayList<InnerComicSpecs> allComics = null;
        if (abbreviationOrFile.startsWith("@")) {
            allComics = NewComicGrabber.processFile(abbreviationOrFile.substring(1));
        } else {
            String date = null;
            if (args.length == 3) {
                date = args[2];
            }
            allComics = new ArrayList<InnerComicSpecs>(1);
            try {
                allComics.add(new InnerComicSpecs(abbreviationOrFile, date, null));
            }
            catch (ParseException pe) {
                System.err.println("\n\nUnable to parse the input: " + pe.getMessage() + "\n");
                System.exit(1);
            }
        }
        Iterator iter = allComics.iterator();
        while (iter.hasNext()) {
            InnerComicSpecs lInnerComicSpecs = (InnerComicSpecs)iter.next();
            GregorianDayRoller roller = new GregorianDayRoller(lInnerComicSpecs.getStartDate(), lInnerComicSpecs.getDays());
            String comic = lInnerComicSpecs.getCode();
            ComicGrabberEngineImplementation engine = new ComicGrabberEngineImplementation();
            try {
                int previousError = 0;
                int previousMonth = roller.getCurrentMonth();
                int previousYear = roller.getCurrentYear();
                int totalError = 0;
                System.out.println("\n############################################\n  Retrieving '" + comic + "'\n  Starting from " + roller.getFormattedCurrentDate("dd/MM/yyyy") + "\n############################################");
                while (previousError < 14) {
                    try {
                        ComicImage image;
                        File outputFile;
                        int year = roller.getCurrentYear();
                        int month = roller.getCurrentMonth();
                        String previousMonthString = (previousMonth < 10 ? "0" : "") + Integer.toString(previousMonth);
                        String currentMonthString = (month < 10 ? "0" : "") + Integer.toString(month);
                        if (month < previousMonth || year < previousYear) {
                            System.out.println("Grabbed " + previousMonthString + "/" + previousYear + " for comic '" + comic + "'.");
                            previousMonth = month;
                            previousYear = year;
                        }
                        URL url = ComicURLFactory.createURL("UCOMICS", comic, roller.getCurrentDate());
                        File outputDir = new File(output, comic + "/" + Integer.toString(year) + "/" + currentMonthString + "/");
                        if (!outputDir.exists()) {
                            outputDir.mkdirs();
                        }
                        if ((outputFile = new File(outputDir, (image = engine.grabComic(url)).getFilename())).exists()) {
                            System.out.println("\n* Found comic '" + outputFile.getName() + "' in output path. Updating complete.");
                            break;
                        }
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outputFile));
                        bos.write(image.getImage());
                        bos.flush();
                        bos.close();
                        previousError = 0;
                    }
                    catch (IOException ioe) {
                        System.err.println("Error for date " + roller.getFormattedCurrentDate("dd/MM/yyyy") + ": " + ioe.getMessage());
                        ++previousError;
                        ++totalError;
                    }
                    roller.getPreviousDay();
                }
                String last = roller.getFormattedCurrentDate("dd/MM/yyyy");
                if (previousError >= 14) {
                    System.out.println("\n\nExiting because the comic was not found for 15 consecutive days on the server.");
                } else {
                    System.out.println("\n\nExiting because update was complete.");
                }
                System.out.println("\n - Last date: " + last + "\n - Total error count: " + totalError + "\n\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Collection processFile(String aFilename) {
        ArrayList<InnerComicSpecs> result = new ArrayList<InnerComicSpecs>(20);
        try {
            BufferedReader br = new BufferedReader(new FileReader(aFilename));
            String line = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#") || line.startsWith("!")) continue;
                StringTokenizer st = new StringTokenizer(line, " ");
                int count = st.countTokens();
                if (count != 2 && count != 3) {
                    System.err.println("Unable to parse line '" + line + "'. Skipping it.");
                    continue;
                }
                String comic = st.nextToken().trim();
                String days = st.nextToken().trim();
                String startdate = null;
                if (count == 3) {
                    startdate = st.nextToken().trim();
                }
                try {
                    result.add(new InnerComicSpecs(comic, days, startdate));
                }
                catch (ParseException pe) {
                    System.err.println("Unable to parse line '" + line + "': " + pe.getMessage() + ". Skipping it.");
                }
            }
            br.close();
        }
        catch (IOException ioe) {
            System.err.println("\n\nUnable to read the specified file '" + aFilename + "': " + ioe.getMessage() + "\n");
            System.exit(1);
        }
        return result;
    }

    private static class InnerComicSpecs {
        private String iCode = null;
        private Date iStartDate = null;
        private int[] iDays = null;

        public InnerComicSpecs(String aCode, String aDays, String aStartDate) throws ParseException {
            this.iCode = aCode;
            this.iDays = this.parseDays(aDays);
            this.iStartDate = this.parseDate(aStartDate);
        }

        public String getCode() {
            return this.iCode;
        }

        public int[] getDays() {
            return this.iDays;
        }

        public Date getStartDate() {
            return this.iStartDate;
        }

        private Date parseDate(String aDateString) throws ParseException {
            Date temp = null;
            if (aDateString != null) {
                try {
                    temp = iSDF.parse(aDateString);
                }
                catch (ParseException pe) {
                    throw new ParseException("Unable to parse date '" + aDateString + "'. please format it as 'dd/MM/yyyy'.", 0);
                }
            }
            return temp;
        }

        private int[] parseDays(String aDaysString) throws ParseException {
            int[] result = null;
            StringTokenizer st = new StringTokenizer(aDaysString, ",");
            int count = st.countTokens();
            result = new int[count];
            if (count > 1) {
                int counter = 0;
                while (st.hasMoreTokens()) {
                    result[counter] = this.parseDayCode(st.nextToken().trim());
                    ++counter;
                }
            } else if (count == 1) {
                String temp = st.nextToken().trim();
                if (!temp.equalsIgnoreCase("all")) {
                    result[0] = this.parseDayCode(temp);
                } else {
                    result = null;
                }
            } else {
                throw new ParseException("No day codes found. Specify at least 'all'.", 0);
            }
            return result;
        }

        private int parseDayCode(String aDayCode) throws ParseException {
            int result = 0;
            if (aDayCode.equalsIgnoreCase("mon")) {
                result = 2;
            } else if (aDayCode.equalsIgnoreCase("tue")) {
                result = 3;
            } else if (aDayCode.equalsIgnoreCase("wed")) {
                result = 4;
            } else if (aDayCode.equalsIgnoreCase("thu")) {
                result = 5;
            } else if (aDayCode.equalsIgnoreCase("fri")) {
                result = 6;
            } else if (aDayCode.equalsIgnoreCase("sat")) {
                result = 7;
            } else if (aDayCode.equalsIgnoreCase("sun")) {
                result = 1;
            } else {
                throw new ParseException("Unrecognized three-letter day code '" + aDayCode + "'.", 0);
            }
            return result;
        }
    }
}

