/*
 * Decompiled with CFR 0.152.
 */
package comics.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;

public class ComicURLFactory {
    public static final String UCOMICS = "UCOMICS";
    private static final SimpleDateFormat iUComicsSDF = new SimpleDateFormat("yyMMdd");
    private static String iUComicsSource = null;
    private static final String UCOMICS_PROPERTIES = "ucomics.properties";
    static /* synthetic */ Class class$comics$core$ComicURLFactory;

    public static URL createURL(String aComicProvider, String aComicName, Calendar aDate) {
        URL url = null;
        if (!aComicProvider.equals(UCOMICS)) {
            throw new IllegalArgumentException("Unknown provider '" + aComicProvider + "'. Please restrict yourself to the constants defined on this class!");
        }
        url = ComicURLFactory.createUComicsURL(aComicName, aDate);
        return url;
    }

    public static URL createURL(String aComicProvider, String aComicName, Date aDate) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(aDate);
        return ComicURLFactory.createURL(aComicProvider, aComicName, gc);
    }

    private static URL createUComicsURL(String aComicName, Calendar aDate) {
        URL url = null;
        try {
            url = new URL(iUComicsSource + aComicName + "/" + aDate.get(1) + "/" + aComicName + iUComicsSDF.format(aDate.getTime()) + ".gif");
        }
        catch (MalformedURLException mfue) {
            mfue.printStackTrace();
        }
        return url;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            InputStream is = (class$comics$core$ComicURLFactory == null ? (class$comics$core$ComicURLFactory = ComicURLFactory.class$("comics.core.ComicURLFactory")) : class$comics$core$ComicURLFactory).getClassLoader().getResourceAsStream(UCOMICS_PROPERTIES);
            if (is == null) {
                throw new FileNotFoundException("You need to have a file called 'ucomics.properties' in the classpath!");
            }
            Properties props = new Properties();
            props.load(is);
            String url = props.getProperty("url");
            if (url == null || url.trim().equals("")) {
                throw new IOException("The 'ucomics.properties' file did not contain the 'url' key, or that key did not have a value!");
            }
            iUComicsSource = url;
        }
        catch (Exception e) {
            System.err.println("\n\nUnable to load UComics comics URL from the 'ucomics.properties' file:\n\n\t" + e.getMessage() + "\n\n");
            System.exit(1);
        }
    }
}

