/*
 * Decompiled with CFR 0.152.
 */
package comics.core;

import comics.interfaces.DayRoller;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class GregorianDayRoller
implements DayRoller {
    private Calendar iCalendar = null;
    private Vector iApplicableDays = null;

    public GregorianDayRoller() {
        this(new Date(), null);
    }

    public GregorianDayRoller(Calendar aStartDate, int[] aApplicableDays) {
        this.setStartDate(aStartDate);
        this.setApplicableDays(aApplicableDays);
    }

    public GregorianDayRoller(Date aStartDate, int[] aApplicableDays) {
        if (aStartDate == null) {
            aStartDate = new Date();
        }
        this.setStartDate(aStartDate);
        this.setApplicableDays(aApplicableDays);
    }

    public Calendar getNextDay() {
        this.rollUntillApplicable(1);
        return this.iCalendar;
    }

    public Calendar getPreviousDay() {
        this.rollUntillApplicable(-1);
        return this.iCalendar;
    }

    public void setApplicableDays(int[] aDays) {
        if (aDays != null) {
            Vector<Integer> temp = new Vector<Integer>(aDays.length);
            for (int i = 0; i < aDays.length; ++i) {
                int lApplicableDay = aDays[i];
                if (lApplicableDay != 2 && lApplicableDay != 3 && lApplicableDay != 4 && lApplicableDay != 5 && lApplicableDay != 6 && lApplicableDay != 7 && lApplicableDay != 1) {
                    throw new IllegalArgumentException("The applicable day you passed (" + lApplicableDay + ") is not a day constant defined on the Calendar interface!");
                }
                temp.add(new Integer(lApplicableDay));
            }
            this.iApplicableDays = temp;
        } else {
            this.iApplicableDays = null;
        }
    }

    public void setStartDate(Calendar aStartDate) {
        this.iCalendar = aStartDate;
    }

    public void setStartDate(Date aStartDate) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(aStartDate);
        this.iCalendar = gc;
    }

    public int getCurrentDayOfMonth() {
        return this.iCalendar.get(5);
    }

    public int getCurrentMonth() {
        return this.iCalendar.get(2) + 1;
    }

    public int getCurrentYear() {
        return this.iCalendar.get(1);
    }

    public Calendar getCurrentDate() {
        if (this.iApplicableDays != null && !this.iApplicableDays.contains(new Integer(this.iCalendar.get(7)))) {
            this.rollUntillApplicable(-1);
        }
        return this.iCalendar;
    }

    public String getFormattedCurrentDate(String aFormatter) {
        this.getCurrentDate();
        SimpleDateFormat sdf = new SimpleDateFormat(aFormatter);
        return sdf.format(this.iCalendar.getTime());
    }

    private void rollUntillApplicable(int aNumberOfDays) {
        boolean satisfied = false;
        while (!satisfied) {
            this.roll(aNumberOfDays);
            if (this.iApplicableDays == null) {
                satisfied = true;
                continue;
            }
            Integer day = new Integer(this.iCalendar.get(7));
            if (!this.iApplicableDays.contains(day)) continue;
            satisfied = true;
        }
    }

    private void roll(int aNumberOfDays) {
        this.iCalendar.add(5, aNumberOfDays);
    }
}

