/*
 * Decompiled with CFR 0.152.
 */
package comics.gui;

import comics.gui.progressbars.DefaultProgressBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PicturePanel
extends JPanel {
    private JLabel lblPicture;
    private ImageIcon imgPicture;
    private JLabel lblCaption;
    private String iParentFolder;
    private Vector allFiles;
    private HashMap comics;
    private int index;
    private DefaultProgressBar progress;
    private JFrame progressFrame;
    private JComboBox cmbComics;
    private JButton btnSelectComic;
    private JCheckBox chkAutoResize;
    private JButton first;
    private JButton last;
    private JButton next;
    private JButton previous;
    private JButton random;
    private JButton chooseFolder;
    private boolean somethingSelected;
    private JFrame iParentFrame;
    private int iMaxHeight;
    private int iMaxWidth;
    private static Properties conversion = null;

    public PicturePanel() {
        block5: {
            this.lblPicture = null;
            this.imgPicture = null;
            this.lblCaption = null;
            this.iParentFolder = null;
            this.allFiles = new Vector();
            this.comics = null;
            this.index = 0;
            this.progress = null;
            this.progressFrame = null;
            this.cmbComics = new JComboBox();
            this.btnSelectComic = new JButton("Select");
            this.chkAutoResize = new JCheckBox("Adjust screen size to comic");
            this.first = new JButton("First");
            this.last = new JButton("Last");
            this.next = new JButton("Next");
            this.previous = new JButton("Previous");
            this.random = new JButton("Random");
            this.chooseFolder = new JButton("Choose parent folder...");
            this.somethingSelected = false;
            this.iParentFrame = null;
            this.iMaxHeight = 0;
            this.iMaxWidth = 0;
            JPanel comp = new JPanel(new BorderLayout(0, 5));
            this.lblPicture = new JLabel();
            this.lblPicture.setToolTipText("Click left button to enlarge, right button to shrink.");
            this.lblPicture.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 2 || e.getButton() == 3) {
                        PicturePanel.this.rescalePicture(-1.5);
                    } else {
                        PicturePanel.this.rescalePicture(1.5);
                    }
                }
            });
            this.lblPicture.setCursor(new Cursor(1));
            this.lblPicture.setHorizontalAlignment(0);
            this.lblPicture.setVerticalAlignment(0);
            this.lblPicture.setVerticalTextPosition(0);
            this.lblPicture.setHorizontalTextPosition(0);
            comp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.lblCaption = new JLabel();
            this.lblCaption.setHorizontalAlignment(0);
            this.lblCaption.setHorizontalTextPosition(0);
            comp.add((Component)new JScrollPane(this.lblPicture), "Center");
            comp.add((Component)this.lblCaption, "South");
            JPanel jpanIntermediate = new JPanel();
            jpanIntermediate.add(this.cmbComics);
            this.btnSelectComic.setMnemonic(83);
            this.btnSelectComic.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String key = (String)PicturePanel.this.cmbComics.getSelectedItem();
                    String name = (String)PicturePanel.this.comics.get(key);
                    PicturePanel.this.somethingSelected = true;
                    PicturePanel.this.setRootFolder(PicturePanel.this.iParentFolder + name);
                }
            });
            jpanIntermediate.add(this.btnSelectComic);
            this.chkAutoResize.setSelected(true);
            jpanIntermediate.add(this.chkAutoResize);
            this.setLayout(new BorderLayout(0, 10));
            this.add((Component)this.getButtons(), "South");
            this.add((Component)comp, "Center");
            this.add((Component)jpanIntermediate, "North");
            try {
                if (conversion == null) {
                    conversion = new Properties();
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream("comics.properties");
                    if (is != null) {
                        conversion.load(is);
                        String folder = conversion.getProperty("rootfolder");
                        File test = new File(folder);
                        if (!test.exists()) {
                            throw new IOException("Unable to find specified folder!");
                        }
                        this.setParentFolder(folder);
                        is.close();
                    }
                }
            }
            catch (Exception e) {
                this.selectParentFolder();
                if (this.iParentFolder != null) break block5;
                System.exit(0);
            }
        }
    }

    public PicturePanel(JFrame aParent) {
        this();
        this.iParentFrame = aParent;
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        this.iMaxHeight = screensize.height;
        this.iMaxWidth = screensize.width;
    }

    public void setPicture(String aFilename) {
        this.imgPicture = new ImageIcon(aFilename, aFilename);
        if (this.chkAutoResize.isSelected()) {
            boolean resizeNecessary = false;
            int height = 0;
            int width = 0;
            if (this.imgPicture.getIconHeight() + 40 > this.lblPicture.getHeight()) {
                resizeNecessary = true;
                height = this.imgPicture.getIconHeight() + 40 - this.lblPicture.getHeight();
            }
            if (this.imgPicture.getIconWidth() + 40 > this.lblPicture.getWidth()) {
                resizeNecessary = true;
                width = this.imgPicture.getIconWidth() + 40 - this.lblPicture.getWidth();
            }
            if (resizeNecessary && this.iParentFrame != null) {
                int newHeight = this.iParentFrame.getHeight() + height;
                int newWidth = this.iParentFrame.getWidth() + width;
                if (newHeight < this.iMaxHeight && newWidth < this.iMaxWidth) {
                    ((Component)this.iParentFrame).setSize(newWidth, newHeight);
                }
            }
        }
        this.lblPicture.setIcon(this.imgPicture);
        this.lblCaption.setText(aFilename);
    }

    public void setPicture(File aFilename) {
        try {
            this.setPicture(aFilename.getCanonicalPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void rescalePicture(double times) {
        if (!this.checkSelected()) {
            return;
        }
        if (times < 0.0) {
            times = -1.0 / times;
        }
        Image image = this.imgPicture.getImage();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        image = image.getScaledInstance((int)((double)width * times), (int)((double)height * times), 4);
        this.imgPicture = new ImageIcon(image, this.imgPicture.getDescription());
        this.lblPicture.setIcon(this.imgPicture);
    }

    public void setRootFolder(String aFolder) {
        this.allFiles = new Vector();
        File root = new File(aFolder);
        this.addContents(root);
        Collections.sort(this.allFiles);
        this.index = 0;
        if (this.somethingSelected) {
            this.setPicture((File)this.allFiles.get(this.index));
            this.previous.setEnabled(false);
        }
    }

    public void setParentFolder(String aFolder) {
        this.comics = new HashMap();
        this.iParentFolder = aFolder.trim();
        if (!this.iParentFolder.endsWith("\\") || !this.iParentFolder.endsWith("/")) {
            this.iParentFolder = this.iParentFolder + "/";
        }
        File[] files = new File(aFolder).listFiles();
        for (int i = 0; i < files.length; ++i) {
            String name;
            File lFile = files[i];
            if (!lFile.isDirectory()) continue;
            String key = name = lFile.getName().trim();
            if (((Hashtable)conversion).containsKey(name)) {
                key = conversion.getProperty(name);
            }
            this.comics.put(key, name);
        }
        Object[] names = this.comics.keySet().toArray();
        Arrays.sort(names);
        this.cmbComics.setModel(new DefaultComboBoxModel<Object>(names));
    }

    public static void main(String[] args) {
        final JFrame tc = new JFrame("Comics!");
        tc.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                tc.dispose();
                System.exit(0);
            }
        });
        PicturePanel pp = new PicturePanel(tc);
        tc.getContentPane().add((Component)pp, "Center");
        ((Component)tc).setBounds(300, 300, 800, 400);
        ((Component)tc).setVisible(true);
    }

    private void addContents(File aFolder) {
        File[] list = aFolder.listFiles();
        this.progressFrame = new JFrame();
        this.progress = new DefaultProgressBar(this.progressFrame, "Loading comics", 0, list.length, "Loading from '" + aFolder.getName() + "'...");
        InnerRecursion ir = new InnerRecursion(list, this.progress);
        ((Component)this.progress).setSize(300, this.progress.getPreferredSize().height);
        Thread t = new Thread(ir);
        t.start();
        ((Component)this.progress).setVisible(true);
        this.progressFrame.dispose();
        if (this.allFiles.size() == 0) {
            JOptionPane.showMessageDialog(this, "No graphics files (.gif, .jpg or .jpeg) found in the specified path!", "No graphics files found!", 2);
            this.somethingSelected = false;
        }
    }

    private JPanel getButtons() {
        JPanel jpanButtons = new JPanel();
        jpanButtons.setLayout(new BoxLayout(jpanButtons, 0));
        this.first.setMnemonic(70);
        this.first.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PicturePanel.this.checkSelected()) {
                    return;
                }
                PicturePanel.this.index = 0;
                PicturePanel.this.setPicture((File)PicturePanel.this.allFiles.get(PicturePanel.this.index));
                PicturePanel.this.previous.setEnabled(false);
                if (!PicturePanel.this.next.isEnabled()) {
                    PicturePanel.this.next.setEnabled(true);
                }
            }
        });
        this.last.setMnemonic(76);
        this.last.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PicturePanel.this.checkSelected()) {
                    return;
                }
                PicturePanel.this.index = PicturePanel.this.allFiles.size() - 1;
                PicturePanel.this.setPicture((File)PicturePanel.this.allFiles.get(PicturePanel.this.index));
                PicturePanel.this.next.setEnabled(false);
                if (!PicturePanel.this.previous.isEnabled()) {
                    PicturePanel.this.previous.setEnabled(true);
                }
            }
        });
        this.random.setMnemonic(82);
        this.random.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PicturePanel.this.checkSelected()) {
                    return;
                }
                PicturePanel.this.index = (int)(Math.random() * (double)PicturePanel.this.allFiles.size());
                PicturePanel.this.setPicture((File)PicturePanel.this.allFiles.get(PicturePanel.this.index));
                if (PicturePanel.this.index > 0 && !PicturePanel.this.previous.isEnabled()) {
                    PicturePanel.this.previous.setEnabled(true);
                }
                if (PicturePanel.this.index < PicturePanel.this.allFiles.size() - 1 && !PicturePanel.this.next.isEnabled()) {
                    PicturePanel.this.next.setEnabled(true);
                }
            }
        });
        this.next.setMnemonic(78);
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PicturePanel.this.checkSelected()) {
                    return;
                }
                if (PicturePanel.this.index < PicturePanel.this.allFiles.size() - 1) {
                    PicturePanel.this.index++;
                    PicturePanel.this.setPicture((File)PicturePanel.this.allFiles.get(PicturePanel.this.index));
                    if (!PicturePanel.this.previous.isEnabled()) {
                        PicturePanel.this.previous.setEnabled(true);
                    }
                } else {
                    PicturePanel.this.next.setEnabled(false);
                }
            }
        });
        this.previous.setMnemonic(80);
        this.previous.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PicturePanel.this.checkSelected()) {
                    return;
                }
                if (PicturePanel.this.index > 0) {
                    PicturePanel.this.index--;
                    PicturePanel.this.setPicture((File)PicturePanel.this.allFiles.get(PicturePanel.this.index));
                    if (!PicturePanel.this.next.isEnabled()) {
                        PicturePanel.this.next.setEnabled(true);
                    }
                } else {
                    PicturePanel.this.previous.setEnabled(false);
                }
            }
        });
        this.chooseFolder.setMnemonic(67);
        this.chooseFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PicturePanel.this.selectParentFolder();
            }
        });
        jpanButtons.add(Box.createHorizontalStrut(15));
        jpanButtons.add(this.chooseFolder);
        jpanButtons.add(Box.createHorizontalGlue());
        jpanButtons.add(this.random);
        jpanButtons.add(Box.createHorizontalStrut(5));
        jpanButtons.add(this.first);
        jpanButtons.add(Box.createHorizontalStrut(5));
        jpanButtons.add(this.previous);
        jpanButtons.add(Box.createHorizontalStrut(5));
        jpanButtons.add(this.next);
        jpanButtons.add(Box.createHorizontalStrut(5));
        jpanButtons.add(this.last);
        jpanButtons.add(Box.createHorizontalStrut(15));
        return jpanButtons;
    }

    private boolean checkSelected() {
        if (!this.somethingSelected) {
            JOptionPane.showMessageDialog(this, "No comic selected to perform requested operation on!", "No comic selected!", 2);
        }
        return this.somethingSelected;
    }

    private void selectParentFolder() {
        JFileChooser fc = new JFileChooser("/");
        fc.setFileSelectionMode(1);
        if (fc.showDialog(this, "Select folder") == 1) {
            return;
        }
        File f = fc.getSelectedFile();
        String parentDir = f.getAbsolutePath();
        this.setParentFolder(parentDir);
    }

    private class InnerRecursion
    implements Runnable {
        private File[] list = null;
        private DefaultProgressBar progress = null;

        public InnerRecursion(File[] aList, DefaultProgressBar aProgress) {
            this.list = aList;
            this.progress = aProgress;
        }

        public void run() {
            for (int i = 0; i < this.list.length; ++i) {
                this.progress.setValue(i);
                this.progress.setMessage("Reading through " + this.list[i]);
                File item = this.list[i];
                if (item.isDirectory()) {
                    this.recurse(item);
                    continue;
                }
                if (!item.getName().endsWith(".gif") && !item.getName().endsWith(".jpg") && !item.getName().endsWith(".GIF") && !item.getName().endsWith(".JPG") && !item.getName().endsWith(".jpeg") && !item.getName().endsWith(".JPEG")) continue;
                PicturePanel.this.allFiles.add(item);
            }
            this.progress.setValue(this.progress.getMaximum());
        }

        private void recurse(File aFile) {
            File[] lList = aFile.listFiles();
            for (int i = 0; i < lList.length; ++i) {
                File item = lList[i];
                if (item.isDirectory()) {
                    this.recurse(item);
                    continue;
                }
                if (!item.getName().endsWith(".gif") && !item.getName().endsWith(".jpg") && !item.getName().endsWith(".GIF") && !item.getName().endsWith(".JPG") && !item.getName().endsWith(".jpeg") && !item.getName().endsWith(".JPEG")) continue;
                PicturePanel.this.allFiles.add(item);
            }
        }
    }
}

