/*
 * Decompiled with CFR 0.152.
 */
package comics.gui.progressbars;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class DefaultProgressBar
extends JDialog {
    private String iMessage = null;
    private int iMinimum = 0;
    private int iMaximum = 0;
    private JLabel lblMessage = null;
    private JProgressBar jpbProgress = null;

    public DefaultProgressBar(Frame aOwner, String aTitle, int aMinimum, int aMaximum) {
        this(aOwner, aTitle, aMinimum, aMaximum, "Progress:");
    }

    public DefaultProgressBar(Frame aOwner, String aTitle, int aMinimum, int aMaximum, String aMessage) {
        super(aOwner, aTitle, true);
        this.iMinimum = aMinimum;
        this.iMaximum = aMaximum;
        this.iMessage = aMessage;
        this.jpbProgress = new JProgressBar(this.iMinimum, this.iMaximum);
        this.jpbProgress.setValue(this.iMinimum);
        this.jpbProgress.setStringPainted(true);
        this.constructScreen();
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(screen.width / 4, screen.height / 4);
    }

    public void setValue(int aValue) {
        if (aValue < this.iMinimum) {
            throw new IllegalArgumentException("Cannot progress to a value (" + aValue + ") that is less than the minimum (" + this.iMinimum + ")!");
        }
        this.jpbProgress.setValue(aValue);
        if (aValue >= this.iMaximum) {
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public int getValue() {
        return this.jpbProgress.getValue();
    }

    public int getMaximum() {
        return this.iMaximum;
    }

    public int getMinimum() {
        return this.iMinimum;
    }

    public void setMessage(String aMessage) {
        this.iMessage = aMessage;
        this.lblMessage.setText(aMessage);
    }

    private void constructScreen() {
        JPanel jpanMain = new JPanel();
        jpanMain.setLayout(new BoxLayout(jpanMain, 1));
        this.lblMessage = new JLabel(this.iMessage);
        jpanMain.add(Box.createVerticalStrut(5));
        jpanMain.add(this.lblMessage);
        jpanMain.add(Box.createVerticalStrut(10));
        jpanMain.add(this.jpbProgress);
        jpanMain.add(Box.createVerticalStrut(5));
        this.getContentPane().add((Component)jpanMain, "Center");
    }
}

